/*
 * Decompiled with CFR 0.152.
 */
package dev.doctor4t.wathe.util;

import dev.doctor4t.wathe.client.particle.HandParticle;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.class_1921;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class HandParticleManager {
    private final CopyOnWriteArrayList<HandParticle> particles = new CopyOnWriteArrayList();
    public static Vector3f vector;

    public void spawn(HandParticle p) {
        this.particles.add(p);
    }

    public void tick() {
        if (this.particles.isEmpty()) {
            return;
        }
        this.particles.forEach(handParticle -> {
            if (!handParticle.tick(1.0f)) {
                this.particles.remove(handParticle);
            }
        });
    }

    public void render(class_4587 matrices, class_4597 vertexConsumers, int light) {
        vector = new Vector3f(0.0f, 0.0f, 1.0f);
        if (this.particles.isEmpty()) {
            return;
        }
        class_4587.class_4665 entry = matrices.method_23760();
        Matrix4f model = entry.method_23761();
        Vector3f right = new Vector3f(1.0f, 0.0f, 0.0f);
        Vector3f up = new Vector3f(0.0f, 1.0f, 0.0f);
        for (HandParticle p : this.particles) {
            class_1921 rl = p.renderLayerFactory.apply(p.texture);
            class_4588 consumer = vertexConsumers.getBuffer(rl);
            float half = p.size * 0.5f;
            Vector3f center = new Vector3f(p.x, p.y, p.z);
            float frameHeight = 1.0f / (float)p.frames;
            int currentFrame = p.loop ? (int)(p.age / p.maxAge * (float)p.frames) % p.frames : Math.min((int)(p.age / p.maxAge * (float)p.frames), p.frames - 1);
            float v0 = frameHeight * (float)currentFrame;
            float v1 = v0 + frameHeight;
            float u0 = 0.0f;
            float u1 = 1.0f;
            Vector3f c1 = new Vector3f((Vector3fc)center).add((Vector3fc)new Vector3f((Vector3fc)right).mul(-half)).add((Vector3fc)new Vector3f((Vector3fc)up).mul(-half));
            Vector3f c2 = new Vector3f((Vector3fc)center).add((Vector3fc)new Vector3f((Vector3fc)right).mul(-half)).add((Vector3fc)new Vector3f((Vector3fc)up).mul(half));
            Vector3f c3 = new Vector3f((Vector3fc)center).add((Vector3fc)new Vector3f((Vector3fc)right).mul(half)).add((Vector3fc)new Vector3f((Vector3fc)up).mul(half));
            Vector3f c4 = new Vector3f((Vector3fc)center).add((Vector3fc)new Vector3f((Vector3fc)right).mul(half)).add((Vector3fc)new Vector3f((Vector3fc)up).mul(-half));
            HandParticleManager.putVertex(consumer, model, c1, u0, v1, p);
            HandParticleManager.putVertex(consumer, model, c2, u0, v0, p);
            HandParticleManager.putVertex(consumer, model, c3, u1, v0, p);
            HandParticleManager.putVertex(consumer, model, c4, u1, v1, p);
        }
    }

    private static void putVertex(class_4588 consumer, Matrix4f model, Vector3f pos, float u, float v, HandParticle p) {
        float a;
        float b;
        float g;
        float r;
        float t = p.age / p.maxAge;
        int n = p.rColors.length;
        if (n == 1) {
            r = p.rColors[0];
            g = p.gColors[0];
            b = p.bColors[0];
        } else {
            float scaled = t * (float)(n - 1);
            int idx = (int)Math.floor(scaled);
            int next = Math.min(idx + 1, n - 1);
            float localT = scaled - (float)idx;
            r = HandParticleManager.lerp(localT, p.rColors[idx], p.rColors[next]);
            g = HandParticleManager.lerp(localT, p.gColors[idx], p.gColors[next]);
            b = HandParticleManager.lerp(localT, p.bColors[idx], p.bColors[next]);
        }
        n = p.aColors.length;
        if (n == 1) {
            a = p.aColors[0];
        } else {
            float scaled = t * (float)(n - 1);
            int idx = (int)Math.floor(scaled);
            int next = Math.min(idx + 1, n - 1);
            float localT = scaled - (float)idx;
            a = HandParticleManager.lerp(localT, p.aColors[idx], p.aColors[next]);
        }
        float displayR = r * a;
        float displayG = g * a;
        float displayB = b * a;
        consumer.method_22918(model, pos.x, pos.y, pos.z).method_22915(displayR, displayG, displayB, a).method_22913(u, v).method_22922(class_4608.field_21444).method_60803(p.light).method_22914(0.0f, 1.0f, 0.0f);
    }

    private static float lerp(float t, float a, float b) {
        return a + t * (b - a);
    }
}

